package com.hero.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.enhancers.Enhancer;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class SkillsPanel extends AbilityPanel {

	class SkillEnhancerMenuItem extends JCheckBoxMenuItem {
		private static final long serialVersionUID = 737095613566716564L;

		SkillsPanel parent;

		String xmlID;

		public SkillEnhancerMenuItem(SkillsPanel par, String display, String ID) {
			super(display);
			xmlID = ID;
			parent = par;

			addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					ArrayList<GenericObject> enhancers = HeroDesigner
							.getActiveHero().getSkills();
					if (isSelected()) {
						for (int i = 0; i < enhancers.size(); i++) {
							GenericObject obj = enhancers.get(i);
							if (obj.getXMLID().equals(xmlID)) {
								return; // already purchased
							}
						}
						LOOP: for (int i = 0; i < HeroDesigner
								.getActiveTemplate().getSkillEnhancers().size(); i++) {
							GenericObject obj = HeroDesigner
									.getActiveTemplate().getSkillEnhancers()
									.get(i);
							if (obj.getXMLID().equals(xmlID)) {
								GenericObject o2 = obj.clone();
								parent.selectionList.addObject(o2);
								break LOOP;
							}
						}
					} else {
						LOOP: for (int i = 0; i < enhancers.size(); i++) {
							GenericObject obj = enhancers.get(i);
							if (obj.getXMLID().equals(xmlID)) {
								Enhancer en = (Enhancer) obj;
								for (int j = 0; j < en.getObjects().size(); j++) {
									GenericObject member = en.getObjects().get(
											j);
									member.setParent(null);
								}
								enhancers.remove(i);
								HeroDesigner.getActiveHero().setDirty(true);
								break LOOP;
							}
						}
					}
					parent.selectionList.updateTotal();
				}
			});
		}

		public String getXMLID() {
			return xmlID;
		}
	}

	private static final long serialVersionUID = 8264817429833117811L;

	JMenu skillEnhancersMenu;

	public SkillsPanel() {
		super();
	}

	protected void checkIndices() {
		selectionList.checkIndices();
		((SkillList) selectionList).setEnhancerLists();
	}

	@Override
	protected GenericObjectList createSelectionList() {
		return new SkillList();
	}

	@Override
	protected String getAvailableLabel() {
		return "Skills";
	}

	@Override
	protected ArrayList<GenericObject> getAvailableObjects() {
		return HeroDesigner.getActiveTemplate().getSkills();
	}

	@Override
	protected ArrayList<GenericObject> getAvailablePrefabs() {
		return HeroDesigner.getInstance().getPrefabSkills();
	}

	@Override
	protected ArrayList<GenericObject> getObjects() {
		return HeroDesigner.getActiveHero().getSkills();
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		skillEnhancersMenu.addMenuListener(new MenuListener() {
			public void menuCanceled(MenuEvent e) {

			}

			public void menuDeselected(MenuEvent e) {

			}

			public void menuSelected(MenuEvent e) {
				// check to see if it should be deselected...
				for (int j = 0; j < skillEnhancersMenu.getItemCount(); j++) {
					boolean found = false;
					SkillEnhancerMenuItem enhancerMI = (SkillEnhancerMenuItem) skillEnhancersMenu
							.getItem(j);
					INNER: for (int i = 0; i < HeroDesigner.getActiveHero()
							.getSkills().size(); i++) {
						GenericObject o = HeroDesigner.getActiveHero()
								.getSkills().get(i);
						if (o.getXMLID().equals(enhancerMI.getXMLID())) {
							found = true;
							break INNER;
						}
					}
					enhancerMI.setSelected(found);
				}
			}
		});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		skillEnhancersMenu = new JMenu("Skill Enhancers");
		// initialize skill enhancers...
		ArrayList<GenericObject> enhancers = HeroDesigner.getActiveTemplate()
				.getSkillEnhancers();
		for (int i = 0; i < enhancers.size(); i++) {
			GenericObject enhancer = enhancers.get(i);
			if (enhancer.getXMLID().equalsIgnoreCase("WELL_CONNECTED")) {
				continue; // WellConnected belongs on the Perks Tab....
			}
			SkillEnhancerMenuItem mi = new SkillEnhancerMenuItem(this, enhancer
					.getDisplay(), enhancer.getXMLID());
			for (int j = 0; j < HeroDesigner.getActiveHero().getSkills().size(); j++) {
				GenericObject comp = HeroDesigner.getActiveHero().getSkills()
						.get(j);
				if (comp.getXMLID().equals(enhancer.getXMLID())) {
					mi.setSelected(true);
				}
			}
			skillEnhancersMenu.add(mi);
		}

		menuBar.add(skillEnhancersMenu);
	}

	@Override
	protected boolean isEquipment() {
		return false;
	}

	@Override
	protected boolean isPower() {
		return false;
	}

	@Override
	public void reset() {
		selectionList.setData(HeroDesigner.getActiveHero().getSkills());
		availableList.setAvailableList(HeroDesigner.getActiveTemplate()
				.getSkills());
		skillEnhancersMenu.removeAll();
		// initialize skill enhancers...
		ArrayList<GenericObject> enhancers = HeroDesigner.getActiveTemplate()
				.getSkillEnhancers();
		for (int i = 0; i < enhancers.size(); i++) {
			GenericObject enhancer = enhancers.get(i);
			if (enhancer.getXMLID().equalsIgnoreCase("WELL_CONNECTED")) {
				continue; // WellConnected belongs on the Perks Tab....
			}
			SkillEnhancerMenuItem mi = new SkillEnhancerMenuItem(this, enhancer
					.getDisplay(), enhancer.getXMLID());
			for (int j = 0; j < HeroDesigner.getActiveHero().getSkills().size(); j++) {
				GenericObject comp = HeroDesigner.getActiveHero().getSkills()
						.get(j);
				if (comp.getXMLID().equals(enhancer.getXMLID())) {
					mi.setSelected(true);
				}
			}
			skillEnhancersMenu.add(mi);
		}
		skillEnhancersMenu.setVisible(skillEnhancersMenu.getItemCount() > 0);
		if (HeroDesigner.getActiveHero().getRules().useSkillMultipliers()) {
			skillEnhancersMenu.setText("Skill Multipliers");
		} else {
			skillEnhancersMenu.setText("Skill Enhancers");
		}
	}
}